<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Query to fetch all categories with Delete_status = 0
$sql = "SELECT * FROM product_variants WHERE Delete_status = 0 ORDER BY variant_ID DESC";

$result = $conn->query($sql);

// Check if categories are found
if ($result && $result->num_rows > 0) {
    $categories = [];

    // Fetch all categories
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }

    // Return the categories as JSON
    echo json_encode(['status' => 'success', 'data' => $categories]);
} else {
    // No categories found
    echo json_encode(['status' => 'error', 'message' => 'No categories found']);
}

$conn->close();
?>
